/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContextMenu;
import filenet.vw.apps.taskman.VWTaskScopeTree;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class VWScopeTreeMouseAdapter
extends MouseAdapter {
    private VWTaskScopeTree m_scopeTree = null;

    public VWScopeTreeMouseAdapter(VWTaskScopeTree scopeTree) {
        this.m_scopeTree = scopeTree;
    }

    public void mousePressed(MouseEvent evt) {
        int selRow = this.m_scopeTree.getRowForLocation(evt.getX(), evt.getY());
        this.m_scopeTree.setSelectionRow(selRow);
        if (evt.isPopupTrigger()) {
            this.createPopUp(evt);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.createPopUp(evt);
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.createPopUp(evt);
        }
    }

    private void createPopUp(MouseEvent evt) {
        VWTaskContextMenu contextMenu = null;
        VWTaskBaseNode taskNode = null;
        TreePath selPath = this.m_scopeTree.getPathForLocation(evt.getX(), evt.getY());
        if (selPath == null) {
            return;
        }
        taskNode = (VWTaskBaseNode)selPath.getLastPathComponent();
        Object obj = evt.getSource();
        Point p = evt.getPoint();
        contextMenu = new VWTaskContextMenu(taskNode, this.m_scopeTree);
        contextMenu.show((JTree)obj, p.x, p.y);
    }
}

